/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObjectGen;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSProxyObject.class)
final class JSProxyObjectGen {
    private JSProxyObjectGen() {
    }

    static {
        LibraryExport.register(JSProxyObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSProxyObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSProxyObject.class, false);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSProxyObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSProxyObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSProxyObject.class)
        private static final class Uncached
        extends JSObjectGen.InteropLibraryExports.Uncached {
            private final TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = this.lookupLanguageReference(JavaScriptLanguage.class);
            private final TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_ = this.lookupContextReference(JavaScriptLanguage.class);

            protected Uncached(Object receiver) {
                super(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return super.accepts(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSProxyObject arg0Value = (JSProxyObject)((Object)arg0Value_);
                return arg0Value.isExecutable(IsCallableNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSProxyObject arg0Value = (JSProxyObject)((Object)arg0Value_);
                return arg0Value.execute(arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropExecuteNodeGen.getUncached(), ExportValueNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSProxyObject)((Object)receiver)).isInstantiable();
            }

            @CompilerDirectives.TruffleBoundary
            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSProxyObject arg0Value = (JSProxyObject)((Object)arg0Value_);
                return arg0Value.instantiate(arg1Value, (JavaScriptLanguage)this.javaScriptLanguageReference_.get(), (JSRealm)this.javaScriptLanguageContextReference_.get(), JSInteropInstantiateNodeGen.getUncached(), ExportValueNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSProxyObject)((Object)receiver)).hasMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSProxyObject)((Object)receiver)).getMetaObject();
            }
        }

        @GeneratedBy(value=JSProxyObject.class)
        private static final class Cached
        extends JSObjectGen.InteropLibraryExports.Cached {
            @CompilerDirectives.CompilationFinal
            private volatile int state_0_;
            @Node.Child
            private KeyInfoNode keyInfo;
            @Node.Child
            private JSInteropGetIteratorNode getIterator;
            @Node.Child
            private ExportValueNode exportValue;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @Node.Child
            private IsCallableNode isExecutableNode__isCallable_;
            @Node.Child
            private JSInteropExecuteNode executeNode__callNode_;
            @Node.Child
            private JSInteropInstantiateNode instantiateNode__callNode_;

            protected Cached(Object receiver) {
                super(receiver);
            }

            public boolean isExecutable(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSProxyObject arg0Value = (JSProxyObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 1) != 0) {
                    return arg0Value.isExecutable(this.isExecutableNode__isCallable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isExecutableNode_AndSpecialize(arg0Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isExecutableNode_AndSpecialize(JSProxyObject arg0Value) {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    this.isExecutableNode__isCallable_ = (IsCallableNode)super.insert((Node)IsCallableNode.create());
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = arg0Value.isExecutable(this.isExecutableNode__isCallable_);
                    return bl;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 1) == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                return NodeCost.MONOMORPHIC;
            }

            public Object execute(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSProxyObject arg0Value = (JSProxyObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 2) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage executeNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm executeNode__realm__ = (JSRealm)javaScriptLanguageContextReference__.get();
                    return arg0Value.execute(arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object executeNode_AndSpecialize(JSProxyObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    JSRealm executeNode__realm__ = null;
                    JavaScriptLanguage executeNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    executeNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    executeNode__realm__ = (JSRealm)javaScriptLanguageContextReference__1.get();
                    this.executeNode__callNode_ = (JSInteropExecuteNode)super.insert((Node)JSInteropExecuteNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.execute(arg1Value, executeNode__language__, executeNode__realm__, this.executeNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean isInstantiable(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSProxyObject)((Object)receiver)).isInstantiable();
            }

            public Object instantiate(Object arg0Value_, Object ... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSProxyObject arg0Value = (JSProxyObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0) {
                    TruffleLanguage.LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    JavaScriptLanguage instantiateNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__.get();
                    TruffleLanguage.ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    JSRealm instantiateNode__realm__ = (JSRealm)javaScriptLanguageContextReference__.get();
                    return arg0Value.instantiate(arg1Value, instantiateNode__language__, instantiateNode__realm__, this.instantiateNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private Object instantiateNode_AndSpecialize(JSProxyObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = this.getLock();
                boolean hasLock = true;
                lock.lock();
                int state_0 = this.state_0_;
                try {
                    JSRealm instantiateNode__realm__ = null;
                    JavaScriptLanguage instantiateNode__language__ = null;
                    TruffleLanguage.LanguageReference javaScriptLanguageReference__1 = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__1 == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__1 = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    instantiateNode__language__ = (JavaScriptLanguage)javaScriptLanguageReference__1.get();
                    TruffleLanguage.ContextReference javaScriptLanguageContextReference__1 = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__1 == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__1 = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    instantiateNode__realm__ = (JSRealm)javaScriptLanguageContextReference__1.get();
                    this.instantiateNode__callNode_ = (JSInteropInstantiateNode)super.insert((Node)JSInteropInstantiateNodeGen.create());
                    if (this.exportValue == null) {
                        this.exportValue = (ExportValueNode)super.insert((Node)ExportValueNode.create());
                    }
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = arg0Value.instantiate(arg1Value, instantiateNode__language__, instantiateNode__realm__, this.instantiateNode__callNode_, this.exportValue);
                    return object;
                }
                finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSProxyObject)((Object)receiver)).hasMetaObject();
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSProxyObject)((Object)receiver)).getMetaObject();
            }
        }
    }
}

